/*
 * write-super.c:
 *
 * Continually write to a field (the fs label) which is not used by the
 * kernel, to test the interaction between the journal state machine
 * checks and background scribbling by tune2fs. --sct 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/file.h>
#include <linux/ext2_fs.h>

int main(int argc, char **argv)
{
	int	fd, i, offset;
	char	buf[1024];
	struct ext2_super_block *sb;
	
	if (argc != 2) {
		fprintf(stderr, "useage: %s <devname>\n", argv[0]);
		exit(1);
	}

	fd = open(argv[1], O_RDWR, 0600);
	if (fd < 0) {
		perror("open");
		exit(1);
	}
	
	/* The ext2/3 superblock is always located at offset 1024,
           regardless of the fs blocksize */
	
	i = pread(fd, buf, 1024, 1024);
	if (i < 1024) {
		if (i < 0) 
			perror("read");
		else
			fprintf(stderr, "short read (%d)\n", i);
		exit(1);
	}
	
	sb = (struct ext2_super_block *) buf;
	offset = sb->s_volume_name - buf;

	while (1) {
		i = pwrite(fd, sb->s_volume_name, 16, 1024+offset);
		if (i < 16) {
			if (i < 0) 
				perror("write");
			else
				fprintf(stderr, "short write (%d)\n", i);
			exit(1);
		}
	}
}
