/*
 * Show file blocks.
 *
 * jeremy@goop.org wrote this.
 */

#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include <linux/fs.h>

static const char *myname;

int main(int argc, char **argv)
{
	int i, err = 0;
	int fd;
	long blksize;
	off_t filesz;
	long fileblks, blk;
	long start = -1, end = -1;
	long first_logical = -1;

	myname = argv[0];

	while((i = getopt(argc, argv, "")) != EOF) {
		switch(i) {
		default:
			err++;
			break;
		}
	}

	if (err || optind != argc-1) {
		fprintf(stderr, "Usage: %s file\n",
			myname);
		exit(1);
	}

	fd = open(argv[optind], O_RDONLY);
	if (fd == -1) {
		perror(argv[optind]);
		exit(1);
	}

	if (ioctl(fd, FIGETBSZ, &blksize) == -1) {
		perror("FIGETBSZ");
		fprintf(stderr, "assuming 4096\n");
		blksize = 4096;
	}

	filesz = lseek(fd, 0, SEEK_END);
	lseek(fd, 0, SEEK_SET);
	fileblks = (filesz + blksize-1) / blksize;

	err = 0;
	for(blk = 0; blk < fileblks; blk++) {
		long devblk = blk;

		if (ioctl(fd, FIBMAP, &devblk) == -1) {
			if (errno == -EPERM) {
				fprintf(stderr, "got root?\n");
				exit(1);
			}
			printf("%ld: %d (%s)\n",
				blk, errno, strerror(errno));
			err++;
		} else {
			if (start == -1) {
				start = devblk;
				end = devblk;
				first_logical = blk;
			} else {
				if (devblk == end + 1) {
					end++;
				} else {
					printf("%ld-%ld: %ld-%ld (%ld)\n",
						first_logical,
						first_logical+(end-start),
						start, end,
						end - start + 1);
					start = devblk;
					end = devblk;
					first_logical = blk;
				}
			}
		}
	}

	if (start != -1)
		printf("%ld-%ld: %ld-%ld (%ld)\n",
			first_logical,
			first_logical+(end-start),
			start, end,
			end - start + 1);

	exit(err ? 1 : 0);
}
