#!/bin/sh
#
# testing/one-shot-recovery.sh
#
# This script tests recovery (!)
#
# 1 : Mount the ext3 FS, set to go readonly after period_of_time
# 2 : Run test_script
# 3 : Wait for the filesystem to go readonly
# 5 : Kill the test_script
# 6 : umount the target fs
# 8 : Mount the target fs			(run in-kernel recovery)
# 9 : unmount the target fs
# 10: Run e2fsck on the target fs		(should exit 0: clean)
#
# Usage:
#	one-shot-recovery.sh /dev/hda1 /mnt/mount-point test_script [jiffies]
#
# The test_script is invoked as:
#	test_script /mnt/mount-point
#
# This one, you must run as root
#

. functions

usage()
{
	echo "Usage: one-shot-recovery.sh /dev/hda1 /mnt/mount-point test_script [jiffies]"
	exit 1
}

PERIOD_OF_TIME=500
if [ $# == 4 ]
then
	PERIOD_OF_TIME=$4
elif [ $# != 3 ]
then
	usage
fi

DEVICE=$1
MOUNT_POINT=$2
TEST_SCRIPT=$3

umount $DEVICE

mount_fs -o ro-after=$PERIOD_OF_TIME	# Mount, timebombed
run_test_script				# Run the test script
wait_for_readonly			# Wait until the fs turns itself immutable
kill_test_script			# Kill the test scripts
unmount_fs				# Unmount it
mount_fs				# Mount normally.  Writable again.  Run recovery
unmount_fs				# Unmount for fsck
run_e2fsck -fn				# Check sanity

