/*
Date: 	Fri, 10 Nov 2006 16:16:27 +0300
From: "Igor A. Valcov" <viaprog@gmail.com>
*/

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#define __BYTES		8192
#define __FILES		1000
#define N		1000

char	buf [__BYTES];

int main()
{
	char fname[1024];
	int nFiles[__FILES];
	int f, i;

	/* Fill buf */
	for (i = 0; i < __BYTES; i++)
		buf [i] = i % 128;

	/* Create and open files */
	for (f = 0; f < __FILES; f++) {
		sprintf (fname, "file-%d", f);
		nFiles [f] = open(fname, O_WRONLY | O_CREAT | O_TRUNC, 0644);
	}

	for (i = 0; i < N; i++) {
		printf("\r%d/%d	 ", i, N);
		fflush(stdout);
		for (f = 1; f < __FILES; f++)
			write(nFiles[f], buf, __BYTES);
	}
	printf("\n");
	printf("syncing\n");

	for (f = 0; f < __FILES; f++) {
		fsync(nFiles [f]);
		close(nFiles [f]);
	}

	return 0;
}
