#!/bin/sh
#
# Run all the tests we can.
#

. ./functions

usage()
{
	echo "Usage: top-level-tests.sh /dev/hda1 /mnt/mntpoint [number_of_reps]"
	exit 1
}


run_tests()
{
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT huge-file.ts
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT create-orphan.ts
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT copy-lib.ts
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT remove-lib.ts 20
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT bonnie++.ts 1000
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT dbench.ts 1500
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT mmap002.ts 1000
	doit ./one-shot-recovery.sh $DEVICE $MOUNT_POINT non-zero-truncate.ts 500
}

NREPS=1
if [ $# == 3 ]
then
	NREPS=$3
elif [ $# != 2 ]
then
	usage
fi

DEVICE=$1
MOUNT_POINT=$2

while [ $NREPS -ne 0 ]
do
	run_tests
	NREPS=$(expr $NREPS - 1)
done
