/*
 * pfm_tests.h: common test definitions
 *
 * Copyright (c) 2008 Google, Inc
 * Contributed by Stephane Eranian <eranian@google.com>
 */
#ifndef __PFM_TEST_SH__
#define __PFM_TESTS_H__

typedef struct {
	char *name;
	int (*func)(int argc, char **argv);
} test_func_t;

#define PFM_TEST(a) { #a, main_##a }
#define DECL_TEST(b)	extern int main_##b(int argc, char **argv)

#define PFM_LOG(fmt, a...) \
	fprintf(stderr, "%s (%s.%d): " fmt "\n", __FILE__, __func__, __LINE__, ## a)

extern int pfmlib_ok;
extern char * read_sysfs(char *fn);
extern int write_sysfs(char *fn, char *val);

#define BPL (sizeof(uint64_t)<<3)
#define LBPL	6

static inline void pfm_bv_set(uint64_t *bv, uint16_t rnum)
{
	bv[rnum>>LBPL] |= 1UL << (rnum&(BPL-1));
}

static inline void pfm_bv_clear(uint64_t *bv, uint16_t rnum)
{
	bv[rnum>>LBPL] &= ~(1UL << (rnum&(BPL-1)));
}

static inline void pfm_bv_copy(uint64_t *d, uint64_t *j, uint16_t n)
{
	if (n <= BPL)
		*d = *j;
	else {
		memcpy(d, j, (n>>LBPL)*sizeof(uint64_t));
	}
}


#endif /* __PFM_TESDTS_H__ */
