/*
 *  x86.h
 *  Copyright 2009 Ramon de Carvalho Valle <ramon@risesecurity.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* from Linux 2.6.30 */

struct syscall_table syscall_table[] = {
    { "restart_syscall"           ,   0,   0 },
    { "exit"                      ,   1,   0 },
    { "fork"                      ,   2,   SYSCALL_IGNORE },
    { "read"                      ,   3,   0 },
    { "write"                     ,   4,   0 },
    { "open"                      ,   5,   0 },
    { "close"                     ,   6,   0 },
    { "waitpid"                   ,   7,   0 },
    { "creat"                     ,   8,   0 },
    { "link"                      ,   9,   0 },
    { "unlink"                    ,  10,   0 },
    { "execve"                    ,  11,   0 },
    { "chdir"                     ,  12,   0 },
    { "time"                      ,  13,   0 },
    { "mknod"                     ,  14,   0 },
    { "chmod"                     ,  15,   0 },
    { "lchown"                    ,  16,   0 },
    { "break"                     ,  17,   0 },
    { "oldstat"                   ,  18,   0 },
    { "lseek"                     ,  19,   0 },
    { "getpid"                    ,  20,   0 },
    { "mount"                     ,  21,   0 },
    { "umount"                    ,  22,   0 },
    { "setuid"                    ,  23,   0 },
    { "getuid"                    ,  24,   0 },
    { "stime"                     ,  25,   SYSCALL_IGNORE },
    { "ptrace"                    ,  26,   0 },
    { "alarm"                     ,  27,   0 },
    { "oldfstat"                  ,  28,   0 },
    { "pause"                     ,  29,   0 },
    { "utime"                     ,  30,   0 },
    { "stty"                      ,  31,   0 },
    { "gtty"                      ,  32,   0 },
    { "access"                    ,  33,   0 },
    { "nice"                      ,  34,   0 },
    { "ftime"                     ,  35,   0 },
    { "sync"                      ,  36,   0 },
    { "kill"                      ,  37,   0 },
    { "rename"                    ,  38,   0 },
    { "mkdir"                     ,  39,   0 },
    { "rmdir"                     ,  40,   0 },
    { "dup"                       ,  41,   0 },
    { "pipe"                      ,  42,   0 },
    { "times"                     ,  43,   0 },
    { "prof"                      ,  44,   0 },
    { "brk"                       ,  45,   0 },
    { "setgid"                    ,  46,   0 },
    { "getgid"                    ,  47,   0 },
    { "signal"                    ,  48,   0 },
    { "geteuid"                   ,  49,   0 },
    { "getegid"                   ,  50,   0 },
    { "acct"                      ,  51,   0 },
    { "umount2"                   ,  52,   0 },
    { "lock"                      ,  53,   0 },
    { "ioctl"                     ,  54,   0 },
    { "fcntl"                     ,  55,   0 },
    { "mpx"                       ,  56,   0 },
    { "setpgid"                   ,  57,   0 },
    { "ulimit"                    ,  58,   0 },
    { "oldolduname"               ,  59,   0 },
    { "umask"                     ,  60,   0 },
    { "chroot"                    ,  61,   0 },
    { "ustat"                     ,  62,   0 },
    { "dup2"                      ,  63,   0 },
    { "getppid"                   ,  64,   0 },
    { "getpgrp"                   ,  65,   0 },
    { "setsid"                    ,  66,   0 },
    { "sigaction"                 ,  67,   0 },
    { "sgetmask"                  ,  68,   0 },
    { "ssetmask"                  ,  69,   0 },
    { "setreuid"                  ,  70,   0 },
    { "setregid"                  ,  71,   0 },
    { "sigsuspend"                ,  72,   0 },
    { "sigpending"                ,  73,   0 },
    { "sethostname"               ,  74,   0 },
    { "setrlimit"                 ,  75,   0 },
    { "getrlimit"                 ,  76,   0 },
    { "getrusage"                 ,  77,   0 },
    { "gettimeofday"              ,  78,   0 },
    { "settimeofday"              ,  79,   0 },
    { "getgroups"                 ,  80,   0 },
    { "setgroups"                 ,  81,   0 },
    { "select"                    ,  82,   0 },
    { "symlink"                   ,  83,   0 },
    { "oldlstat"                  ,  84,   0 },
    { "readlink"                  ,  85,   0 },
    { "uselib"                    ,  86,   0 },
    { "swapon"                    ,  87,   0 },
    { "reboot"                    ,  88,   SYSCALL_IGNORE },
    { "readdir"                   ,  89,   0 },
    { "mmap"                      ,  90,   0 },
    { "munmap"                    ,  91,   0 },
    { "truncate"                  ,  92,   0 },
    { "ftruncate"                 ,  93,   0 },
    { "fchmod"                    ,  94,   0 },
    { "fchown"                    ,  95,   0 },
    { "getpriority"               ,  96,   0 },
    { "setpriority"               ,  97,   0 },
    { "profil"                    ,  98,   0 },
    { "statfs"                    ,  99,   0 },
    { "fstatfs"                   , 100,   0 },
    { "ioperm"                    , 101,   0 },
    { "socketcall"                , 102,   0 },
    { "syslog"                    , 103,   0 },
    { "setitimer"                 , 104,   0 },
    { "getitimer"                 , 105,   0 },
    { "stat"                      , 106,   0 },
    { "lstat"                     , 107,   0 },
    { "fstat"                     , 108,   0 },
    { "olduname"                  , 109,   0 },
    { "iopl"                      , 110,   0 },
    { "vhangup"                   , 111,   SYSCALL_IGNORE },
    { "idle"                      , 112,   0 },
    { "vm86old"                   , 113,   0 },
    { "wait4"                     , 114,   0 },
    { "swapoff"                   , 115,   0 },
    { "sysinfo"                   , 116,   0 },
    { "ipc"                       , 117,   0 },
    { "fsync"                     , 118,   0 },
    { "sigreturn"                 , 119,   0 },
    { "clone"                     , 120,   SYSCALL_IGNORE },
    { "setdomainname"             , 121,   0 },
    { "uname"                     , 122,   0 },
    { "modify_ldt"                , 123,   0 },
    { "adjtimex"                  , 124,   0 },
    { "mprotect"                  , 125,   0 },
    { "sigprocmask"               , 126,   0 },
    { "create_module"             , 127,   0 },
    { "init_module"               , 128,   0 },
    { "delete_module"             , 129,   0 },
    { "get_kernel_syms"           , 130,   0 },
    { "quotactl"                  , 131,   0 },
    { "getpgid"                   , 132,   0 },
    { "fchdir"                    , 133,   0 },
    { "bdflush"                   , 134,   0 },
    { "sysfs"                     , 135,   0 },
    { "personality"               , 136,   0 },
    { "afs_syscall"               , 137,   0 },
    { "setfsuid"                  , 138,   0 },
    { "setfsgid"                  , 139,   0 },
    { "_llseek"                   , 140,   0 },
    { "getdents"                  , 141,   0 },
    { "_newselect"                , 142,   0 },
    { "flock"                     , 143,   0 },
    { "msync"                     , 144,   0 },
    { "readv"                     , 145,   0 },
    { "writev"                    , 146,   0 },
    { "getsid"                    , 147,   0 },
    { "fdatasync"                 , 148,   0 },
    { "_sysctl"                   , 149,   0 },
    { "mlock"                     , 150,   0 },
    { "munlock"                   , 151,   0 },
    { "mlockall"                  , 152,   0 },
    { "munlockall"                , 153,   0 },
    { "sched_setparam"            , 154,   0 },
    { "sched_getparam"            , 155,   0 },
    { "sched_setscheduler"        , 156,   0 },
    { "sched_getscheduler"        , 157,   0 },
    { "sched_yield"               , 158,   0 },
    { "sched_get_priority_max"    , 159,   0 },
    { "sched_get_priority_min"    , 160,   0 },
    { "sched_rr_get_interval"     , 161,   0 },
    { "nanosleep"                 , 162,   0 },
    { "mremap"                    , 163,   0 },
    { "setresuid"                 , 164,   0 },
    { "getresuid"                 , 165,   0 },
    { "vm86"                      , 166,   0 },
    { "query_module"              , 167,   0 },
    { "poll"                      , 168,   0 },
    { "nfsservctl"                , 169,   0 },
    { "setresgid"                 , 170,   0 },
    { "getresgid"                 , 171,   0 },
    { "prctl"                     , 172,   0 },
    { "rt_sigreturn"              , 173,   0 },
    { "rt_sigaction"              , 174,   0 },
    { "rt_sigprocmask"            , 175,   0 },
    { "rt_sigpending"             , 176,   0 },
    { "rt_sigtimedwait"           , 177,   0 },
    { "rt_sigqueueinfo"           , 178,   0 },
    { "rt_sigsuspend"             , 179,   0 },
    { "pread64"                   , 180,   0 },
    { "pwrite64"                  , 181,   0 },
    { "chown"                     , 182,   0 },
    { "getcwd"                    , 183,   0 },
    { "capget"                    , 184,   0 },
    { "capset"                    , 185,   0 },
    { "sigaltstack"               , 186,   0 },
    { "sendfile"                  , 187,   0 },
    { "getpmsg"                   , 188,   0 },
    { "putpmsg"                   , 189,   0 },
    { "vfork"                     , 190,   SYSCALL_IGNORE },
    { "ugetrlimit"                , 191,   0 },
    { "mmap2"                     , 192,   0 },
    { "truncate64"                , 193,   0 },
    { "ftruncate64"               , 194,   0 },
    { "stat64"                    , 195,   0 },
    { "lstat64"                   , 196,   0 },
    { "fstat64"                   , 197,   0 },
    { "lchown32"                  , 198,   0 },
    { "getuid32"                  , 199,   0 },
    { "getgid32"                  , 200,   0 },
    { "geteuid32"                 , 201,   0 },
    { "getegid32"                 , 202,   0 },
    { "setreuid32"                , 203,   0 },
    { "setregid32"                , 204,   0 },
    { "getgroups32"               , 205,   0 },
    { "setgroups32"               , 206,   0 },
    { "fchown32"                  , 207,   0 },
    { "setresuid32"               , 208,   0 },
    { "getresuid32"               , 209,   0 },
    { "setresgid32"               , 210,   0 },
    { "getresgid32"               , 211,   0 },
    { "chown32"                   , 212,   0 },
    { "setuid32"                  , 213,   0 },
    { "setgid32"                  , 214,   0 },
    { "setfsuid32"                , 215,   0 },
    { "setfsgid32"                , 216,   0 },
    { "pivot_root"                , 217,   0 },
    { "mincore"                   , 218,   0 },
    { "madvise"                   , 219,   0 },
    { "madvise1"                  , 219,   0 },
    { "getdents64"                , 220,   0 },
    { "fcntl64"                   , 221,   0 },
    { "gettid"                    , 224,   0 },
    { "readahead"                 , 225,   0 },
    { "setxattr"                  , 226,   0 },
    { "lsetxattr"                 , 227,   0 },
    { "fsetxattr"                 , 228,   0 },
    { "getxattr"                  , 229,   0 },
    { "lgetxattr"                 , 230,   0 },
    { "fgetxattr"                 , 231,   0 },
    { "listxattr"                 , 232,   0 },
    { "llistxattr"                , 233,   0 },
    { "flistxattr"                , 234,   0 },
    { "removexattr"               , 235,   0 },
    { "lremovexattr"              , 236,   0 },
    { "fremovexattr"              , 237,   0 },
    { "tkill"                     , 238,   0 },
    { "sendfile64"                , 239,   0 },
    { "futex"                     , 240,   0 },
    { "sched_setaffinity"         , 241,   0 },
    { "sched_getaffinity"         , 242,   0 },
    { "set_thread_area"           , 243,   0 },
    { "get_thread_area"           , 244,   0 },
    { "io_setup"                  , 245,   0 },
    { "io_destroy"                , 246,   0 },
    { "io_getevents"              , 247,   0 },
    { "io_submit"                 , 248,   0 },
    { "io_cancel"                 , 249,   0 },
    { "fadvise64"                 , 250,   0 },
    { "exit_group"                , 252,   0 },
    { "lookup_dcookie"            , 253,   0 },
    { "epoll_create"              , 254,   0 },
    { "epoll_ctl"                 , 255,   0 },
    { "epoll_wait"                , 256,   0 },
    { "remap_file_pages"          , 257,   0 },
    { "set_tid_address"           , 258,   0 },
    { "timer_create"              , 259,   0 },
    { "timer_settime"             , 260,   0 },
    { "timer_gettime"             , 261,   0 },
    { "timer_getoverrun"          , 262,   0 },
    { "timer_delete"              , 263,   0 },
    { "clock_settime"             , 264,   0 },
    { "clock_gettime"             , 265,   0 },
    { "clock_getres"              , 266,   0 },
    { "clock_nanosleep"           , 267,   0 },
    { "statfs64"                  , 268,   0 },
    { "fstatfs64"                 , 269,   0 },
    { "tgkill"                    , 270,   0 },
    { "utimes"                    , 271,   0 },
    { "fadvise64_64"              , 272,   0 },
    { "vserver"                   , 273,   0 },
    { "mbind"                     , 274,   0 },
    { "get_mempolicy"             , 275,   0 },
    { "set_mempolicy"             , 276,   0 },
    { "mq_open"                   , 277,   0 },
    { "mq_unlink"                 , 278,   0 },
    { "mq_timedsend"              , 279,   0 },
    { "mq_timedreceive"           , 280,   0 },
    { "mq_notify"                 , 281,   0 },
    { "mq_getsetattr"             , 282,   0 },
    { "kexec_load"                , 283,   0 },
    { "waitid"                    , 284,   0 },
    { "add_key"                   , 286,   0 },
    { "request_key"               , 287,   0 },
    { "keyctl"                    , 288,   0 },
    { "ioprio_set"                , 289,   0 },
    { "ioprio_get"                , 290,   0 },
    { "inotify_init"              , 291,   0 },
    { "inotify_add_watch"         , 292,   0 },
    { "inotify_rm_watch"          , 293,   0 },
    { "migrate_pages"             , 294,   0 },
    { "openat"                    , 295,   0 },
    { "mkdirat"                   , 296,   0 },
    { "mknodat"                   , 297,   0 },
    { "fchownat"                  , 298,   0 },
    { "futimesat"                 , 299,   0 },
    { "fstatat64"                 , 300,   0 },
    { "unlinkat"                  , 301,   0 },
    { "renameat"                  , 302,   0 },
    { "linkat"                    , 303,   0 },
    { "symlinkat"                 , 304,   0 },
    { "readlinkat"                , 305,   0 },
    { "fchmodat"                  , 306,   0 },
    { "faccessat"                 , 307,   0 },
    { "pselect6"                  , 308,   0 },
    { "ppoll"                     , 309,   0 },
    { "unshare"                   , 310,   0 },
    { "set_robust_list"           , 311,   0 },
    { "get_robust_list"           , 312,   0 },
    { "splice"                    , 313,   0 },
    { "sync_file_range"           , 314,   0 },
    { "tee"                       , 315,   0 },
    { "vmsplice"                  , 316,   0 },
    { "move_pages"                , 317,   0 },
    { "getcpu"                    , 318,   0 },
    { "epoll_pwait"               , 319,   0 },
    { "utimensat"                 , 320,   0 },
    { "signalfd"                  , 321,   0 },
    { "timerfd_create"            , 322,   0 },
    { "eventfd"                   , 323,   0 },
    { "fallocate"                 , 324,   0 },
    { "timerfd_settime"           , 325,   0 },
    { "timerfd_gettime"           , 326,   0 },
    { "signalfd4"                 , 327,   0 },
    { "eventfd2"                  , 328,   0 },
    { "epoll_create1"             , 329,   0 },
    { "dup3"                      , 330,   0 },
    { "pipe2"                     , 331,   0 },
    { "inotify_init1"             , 332,   0 },
    { "preadv"                    , 333,   0 },
    { "pwritev"                   , 334,   0 },
    { ""                          ,   0,   SYSCALL_END }
};
