/*
 *  s390.h
 *  Copyright 2009 Ramon de Carvalho Valle <ramon@risesecurity.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* from Linux 2.6.30 */

struct syscall_table syscall_table[] = {
    { "exit"                      ,   1,   0 },
    { "fork"                      ,   2,   SYSCALL_IGNORE },
    { "read"                      ,   3,   0 },
    { "write"                     ,   4,   0 },
    { "open"                      ,   5,   0 },
    { "close"                     ,   6,   0 },
    { "restart_syscall"           ,   7,   0 },
    { "creat"                     ,   8,   0 },
    { "link"                      ,   9,   0 },
    { "unlink"                    ,  10,   0 },
    { "execve"                    ,  11,   0 },
    { "chdir"                     ,  12,   0 },
    { "mknod"                     ,  14,   0 },
    { "chmod"                     ,  15,   0 },
    { "lseek"                     ,  19,   0 },
    { "getpid"                    ,  20,   0 },
    { "mount"                     ,  21,   0 },
    { "umount"                    ,  22,   0 },
    { "ptrace"                    ,  26,   0 },
    { "alarm"                     ,  27,   0 },
    { "pause"                     ,  29,   0 },
    { "utime"                     ,  30,   0 },
    { "access"                    ,  33,   0 },
    { "nice"                      ,  34,   0 },
    { "sync"                      ,  36,   0 },
    { "kill"                      ,  37,   0 },
    { "rename"                    ,  38,   0 },
    { "mkdir"                     ,  39,   0 },
    { "rmdir"                     ,  40,   0 },
    { "dup"                       ,  41,   0 },
    { "pipe"                      ,  42,   0 },
    { "times"                     ,  43,   0 },
    { "brk"                       ,  45,   0 },
    { "signal"                    ,  48,   0 },
    { "acct"                      ,  51,   0 },
    { "umount2"                   ,  52,   0 },
    { "ioctl"                     ,  54,   0 },
    { "fcntl"                     ,  55,   0 },
    { "setpgid"                   ,  57,   0 },
    { "umask"                     ,  60,   0 },
    { "chroot"                    ,  61,   0 },
    { "ustat"                     ,  62,   0 },
    { "dup2"                      ,  63,   0 },
    { "getppid"                   ,  64,   0 },
    { "getpgrp"                   ,  65,   0 },
    { "setsid"                    ,  66,   0 },
    { "sigaction"                 ,  67,   0 },
    { "sigsuspend"                ,  72,   0 },
    { "sigpending"                ,  73,   0 },
    { "sethostname"               ,  74,   0 },
    { "setrlimit"                 ,  75,   0 },
    { "getrusage"                 ,  77,   0 },
    { "gettimeofday"              ,  78,   0 },
    { "settimeofday"              ,  79,   0 },
    { "symlink"                   ,  83,   0 },
    { "readlink"                  ,  85,   0 },
    { "uselib"                    ,  86,   0 },
    { "swapon"                    ,  87,   0 },
    { "reboot"                    ,  88,   SYSCALL_IGNORE },
    { "readdir"                   ,  89,   0 },
    { "mmap"                      ,  90,   0 },
    { "munmap"                    ,  91,   0 },
    { "truncate"                  ,  92,   0 },
    { "ftruncate"                 ,  93,   0 },
    { "fchmod"                    ,  94,   0 },
    { "getpriority"               ,  96,   0 },
    { "setpriority"               ,  97,   0 },
    { "statfs"                    ,  99,   0 },
    { "fstatfs"                   , 100,   0 },
    { "socketcall"                , 102,   0 },
    { "syslog"                    , 103,   0 },
    { "setitimer"                 , 104,   0 },
    { "getitimer"                 , 105,   0 },
    { "stat"                      , 106,   0 },
    { "lstat"                     , 107,   0 },
    { "fstat"                     , 108,   0 },
    { "lookup_dcookie"            , 110,   0 },
    { "vhangup"                   , 111,   SYSCALL_IGNORE },
    { "idle"                      , 112,   0 },
    { "wait4"                     , 114,   0 },
    { "swapoff"                   , 115,   0 },
    { "sysinfo"                   , 116,   0 },
    { "ipc"                       , 117,   0 },
    { "fsync"                     , 118,   0 },
    { "sigreturn"                 , 119,   0 },
    { "clone"                     , 120,   SYSCALL_IGNORE },
    { "setdomainname"             , 121,   0 },
    { "uname"                     , 122,   0 },
    { "adjtimex"                  , 124,   0 },
    { "mprotect"                  , 125,   0 },
    { "sigprocmask"               , 126,   0 },
    { "create_module"             , 127,   0 },
    { "init_module"               , 128,   0 },
    { "delete_module"             , 129,   0 },
    { "get_kernel_syms"           , 130,   0 },
    { "quotactl"                  , 131,   0 },
    { "getpgid"                   , 132,   0 },
    { "fchdir"                    , 133,   0 },
    { "bdflush"                   , 134,   0 },
    { "sysfs"                     , 135,   0 },
    { "personality"               , 136,   0 },
    { "afs_syscall"               , 137,   0 },
    { "getdents"                  , 141,   0 },
    { "flock"                     , 143,   0 },
    { "msync"                     , 144,   0 },
    { "readv"                     , 145,   0 },
    { "writev"                    , 146,   0 },
    { "getsid"                    , 147,   0 },
    { "fdatasync"                 , 148,   0 },
    { "_sysctl"                   , 149,   0 },
    { "mlock"                     , 150,   0 },
    { "munlock"                   , 151,   0 },
    { "mlockall"                  , 152,   0 },
    { "munlockall"                , 153,   0 },
    { "sched_setparam"            , 154,   0 },
    { "sched_getparam"            , 155,   0 },
    { "sched_setscheduler"        , 156,   0 },
    { "sched_getscheduler"        , 157,   0 },
    { "sched_yield"               , 158,   0 },
    { "sched_get_priority_max"    , 159,   0 },
    { "sched_get_priority_min"    , 160,   0 },
    { "sched_rr_get_interval"     , 161,   0 },
    { "nanosleep"                 , 162,   0 },
    { "mremap"                    , 163,   0 },
    { "query_module"              , 167,   0 },
    { "poll"                      , 168,   0 },
    { "nfsservctl"                , 169,   0 },
    { "prctl"                     , 172,   0 },
    { "rt_sigreturn"              , 173,   0 },
    { "rt_sigaction"              , 174,   0 },
    { "rt_sigprocmask"            , 175,   0 },
    { "rt_sigpending"             , 176,   0 },
    { "rt_sigtimedwait"           , 177,   0 },
    { "rt_sigqueueinfo"           , 178,   0 },
    { "rt_sigsuspend"             , 179,   0 },
    { "pread64"                   , 180,   0 },
    { "pwrite64"                  , 181,   0 },
    { "getcwd"                    , 183,   0 },
    { "capget"                    , 184,   0 },
    { "capset"                    , 185,   0 },
    { "sigaltstack"               , 186,   0 },
    { "sendfile"                  , 187,   0 },
    { "getpmsg"                   , 188,   0 },
    { "putpmsg"                   , 189,   0 },
    { "vfork"                     , 190,   SYSCALL_IGNORE },
    { "pivot_root"                , 217,   0 },
    { "mincore"                   , 218,   0 },
    { "madvise"                   , 219,   0 },
    { "getdents64"                , 220,   0 },
    { "readahead"                 , 222,   0 },
    { "setxattr"                  , 224,   0 },
    { "lsetxattr"                 , 225,   0 },
    { "fsetxattr"                 , 226,   0 },
    { "getxattr"                  , 227,   0 },
    { "lgetxattr"                 , 228,   0 },
    { "fgetxattr"                 , 229,   0 },
    { "listxattr"                 , 230,   0 },
    { "llistxattr"                , 231,   0 },
    { "flistxattr"                , 232,   0 },
    { "removexattr"               , 233,   0 },
    { "lremovexattr"              , 234,   0 },
    { "fremovexattr"              , 235,   0 },
    { "gettid"                    , 236,   0 },
    { "tkill"                     , 237,   0 },
    { "futex"                     , 238,   0 },
    { "sched_setaffinity"         , 239,   0 },
    { "sched_getaffinity"         , 240,   0 },
    { "tgkill"                    , 241,   0 },
    { "io_setup"                  , 243,   0 },
    { "io_destroy"                , 244,   0 },
    { "io_getevents"              , 245,   0 },
    { "io_submit"                 , 246,   0 },
    { "io_cancel"                 , 247,   0 },
    { "exit_group"                , 248,   0 },
    { "epoll_create"              , 249,   0 },
    { "epoll_ctl"                 , 250,   0 },
    { "epoll_wait"                , 251,   0 },
    { "set_tid_address"           , 252,   0 },
    { "fadvise64"                 , 253,   0 },
    { "timer_create"              , 254,   0 },
    { "timer_settime"             , 255,   0 },
    { "timer_gettime"             , 256,   0 },
    { "timer_getoverrun"          , 257,   0 },
    { "timer_delete"              , 258,   0 },
    { "clock_settime"             , 259,   0 },
    { "clock_gettime"             , 260,   0 },
    { "clock_getres"              , 261,   0 },
    { "clock_nanosleep"           , 262,   0 },
    { "statfs64"                  , 265,   0 },
    { "fstatfs64"                 , 266,   0 },
    { "remap_file_pages"          , 267,   0 },
    { "mq_open"                   , 271,   0 },
    { "mq_unlink"                 , 272,   0 },
    { "mq_timedsend"              , 273,   0 },
    { "mq_timedreceive"           , 274,   0 },
    { "mq_notify"                 , 275,   0 },
    { "mq_getsetattr"             , 276,   0 },
    { "kexec_load"                , 277,   0 },
    { "add_key"                   , 278,   0 },
    { "request_key"               , 279,   0 },
    { "keyctl"                    , 280,   0 },
    { "waitid"                    , 281,   0 },
    { "ioprio_set"                , 282,   0 },
    { "ioprio_get"                , 283,   0 },
    { "inotify_init"              , 284,   0 },
    { "inotify_add_watch"         , 285,   0 },
    { "inotify_rm_watch"          , 286,   0 },
    { "openat"                    , 288,   0 },
    { "mkdirat"                   , 289,   0 },
    { "mknodat"                   , 290,   0 },
    { "fchownat"                  , 291,   0 },
    { "futimesat"                 , 292,   0 },
    { "unlinkat"                  , 294,   0 },
    { "renameat"                  , 295,   0 },
    { "linkat"                    , 296,   0 },
    { "symlinkat"                 , 297,   0 },
    { "readlinkat"                , 298,   0 },
    { "fchmodat"                  , 299,   0 },
    { "faccessat"                 , 300,   0 },
    { "pselect6"                  , 301,   0 },
    { "ppoll"                     , 302,   0 },
    { "unshare"                   , 303,   0 },
    { "set_robust_list"           , 304,   0 },
    { "get_robust_list"           , 305,   0 },
    { "splice"                    , 306,   0 },
    { "sync_file_range"           , 307,   0 },
    { "tee"                       , 308,   0 },
    { "vmsplice"                  , 309,   0 },
    { "getcpu"                    , 311,   0 },
    { "epoll_pwait"               , 312,   0 },
    { "utimes"                    , 313,   0 },
    { "fallocate"                 , 314,   0 },
    { "utimensat"                 , 315,   0 },
    { "signalfd"                  , 316,   0 },
    { "timerfd"                   , 317,   0 },
    { "eventfd"                   , 318,   0 },
    { "timerfd_create"            , 319,   0 },
    { "timerfd_settime"           , 320,   0 },
    { "timerfd_gettime"           , 321,   0 },
    { "signalfd4"                 , 322,   0 },
    { "eventfd2"                  , 323,   0 },
    { "inotify_init1"             , 324,   0 },
    { "pipe2"                     , 325,   0 },
    { "dup3"                      , 326,   0 },
    { "epoll_create1"             , 327,   0 },
#ifndef __s390x__
    { "time"                      ,  13,   0 },
    { "lchown"                    ,  16,   0 },
    { "setuid"                    ,  23,   0 },
    { "getuid"                    ,  24,   0 },
    { "stime"                     ,  25,   SYSCALL_IGNORE },
    { "setgid"                    ,  46,   0 },
    { "getgid"                    ,  47,   0 },
    { "geteuid"                   ,  49,   0 },
    { "getegid"                   ,  50,   0 },
    { "setreuid"                  ,  70,   0 },
    { "setregid"                  ,  71,   0 },
    { "getrlimit"                 ,  76,   0 },
    { "getgroups"                 ,  80,   0 },
    { "setgroups"                 ,  81,   0 },
    { "fchown"                    ,  95,   0 },
    { "ioperm"                    , 101,   0 },
    { "setfsuid"                  , 138,   0 },
    { "setfsgid"                  , 139,   0 },
    { "_llseek"                   , 140,   0 },
    { "_newselect"                , 142,   0 },
    { "setresuid"                 , 164,   0 },
    { "getresuid"                 , 165,   0 },
    { "setresgid"                 , 170,   0 },
    { "getresgid"                 , 171,   0 },
    { "chown"                     , 182,   0 },
    { "ugetrlimit"                , 191,   0 },
    { "mmap2"                     , 192,   0 },
    { "truncate64"                , 193,   0 },
    { "ftruncate64"               , 194,   0 },
    { "stat64"                    , 195,   0 },
    { "lstat64"                   , 196,   0 },
    { "fstat64"                   , 197,   0 },
    { "lchown32"                  , 198,   0 },
    { "getuid32"                  , 199,   0 },
    { "getgid32"                  , 200,   0 },
    { "geteuid32"                 , 201,   0 },
    { "getegid32"                 , 202,   0 },
    { "setreuid32"                , 203,   0 },
    { "setregid32"                , 204,   0 },
    { "getgroups32"               , 205,   0 },
    { "setgroups32"               , 206,   0 },
    { "fchown32"                  , 207,   0 },
    { "setresuid32"               , 208,   0 },
    { "getresuid32"               , 209,   0 },
    { "setresgid32"               , 210,   0 },
    { "getresgid32"               , 211,   0 },
    { "chown32"                   , 212,   0 },
    { "setuid32"                  , 213,   0 },
    { "setgid32"                  , 214,   0 },
    { "setfsuid32"                , 215,   0 },
    { "setfsgid32"                , 216,   0 },
    { "fcntl64"                   , 221,   0 },
    { "sendfile64"                , 223,   0 },
    { "fadvise64_64"              , 264,   0 },
    { "fstatat64"                 , 293,   0 },
#else
    { "select"                    , 142,   0 },
    { "getrlimit"                 , 191,   0 },
    { "lchown"                    , 198,   0 },
    { "getuid"                    , 199,   0 },
    { "getgid"                    , 200,   0 },
    { "geteuid"                   , 201,   0 },
    { "getegid"                   , 202,   0 },
    { "setreuid"                  , 203,   0 },
    { "setregid"                  , 204,   0 },
    { "getgroups"                 , 205,   0 },
    { "setgroups"                 , 206,   0 },
    { "fchown"                    , 207,   0 },
    { "setresuid"                 , 208,   0 },
    { "getresuid"                 , 209,   0 },
    { "setresgid"                 , 210,   0 },
    { "getresgid"                 , 211,   0 },
    { "chown"                     , 212,   0 },
    { "setuid"                    , 213,   0 },
    { "setgid"                    , 214,   0 },
    { "setfsuid"                  , 215,   0 },
    { "setfsgid"                  , 216,   0 },
    { "newfstatat"                , 293,   0 },
#endif
    { ""                          ,   0,   SYSCALL_END }
};
