/*
 *  flail.h
 *  Copyright 2009 Ramon de Carvalho Valle <ramon@risesecurity.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

struct syscall_table {
	char *name;
	int number;
	int flags;
};

int num_syscalls = 0;

#define SYSCALL_IGNORE  1
#define SYSCALL_END     2

#define syscall_name(index) \
	syscall_table[index].name

#define syscall_number(index) \
	syscall_table[index].number

#define syscall_ignore(index) \
	syscall_table[index].flags & SYSCALL_IGNORE

#define syscall_end(index) \
	syscall_table[index].flags & SYSCALL_END

#define random_syscall_number() \
	rand_int(num_syscalls) - 1
