/*
 * test_sysfs.c: test perfmon sysfs API
 *
 * Copyright (c) 2008 Google, Inc
 * Contributed by Stephane Eranian <eranian@google.com>
 */

#include <sys/types.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "pfm_tests.h"

static int check_version(void)
{
	int fd;
	int ret = -1;
	ssize_t s;
	char buf[24];

	fd = open("/sys/kernel/perfmon/version", O_RDONLY);
	if (fd == -1) {
		PFM_LOG("cannot open /sys/kernel/perfmon/version: %d", errno);
		return -1;
	}
	s = read(fd, buf, sizeof(buf));
	if (s < 3) {
		PFM_LOG("invalid size ofr /sys/perfmon/...version %zd", s);
		goto error;
	}
	close(fd);
	ret = 0;
error:
	close(fd);
	return ret;
}

static int check_formats(void)
{
	int ret;
	struct stat st;

	ret = stat("/sys/kernel/perfmon/formats/default", &st);
	if (ret) {
		PFM_LOG("cannot access /sys/kernel/perfmon/formats/default: %d", errno);
		return -1;
	}
	return 0;
}

int main_sysfs(void)
{
	int ret;

	printf("sysfs.test0   "); fflush(stdout);
	ret = check_version();
	printf("[%s]\n", ret == -1 ? "FAIL" : ret == -2 ? "SKIP" : "PASS");

	printf("sysfs.test1   "); fflush(stdout);
	ret = check_formats();
	printf("[%s]\n", ret == -1 ? "FAIL" : ret == -2 ? "SKIP" : "PASS");

	return ret;
}
