
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <sched.h>
#include <signal.h>
#include <sys/mman.h>
#include <setjmp.h>

#include "fadvise.h"

int fd;
char *map;
char stack[64*1024];
char writebuf[4096];
int exitted;
sigjmp_buf env;

void do_exit(int code)
{
	exitted = 1;
	fprintf(stderr, "do_exit(%d)\n", code);
	exit(code);
}

int unmapper(void *p)
{
	while (!exitted) {
		if (madvise(map, 4096, MADV_DONTNEED) < 0) {
			perror("madvise");
			do_exit(1);
		}
		if (__posix_fadvise64(fd, 0, 4096, POSIX_FADV_DONTNEED) < 0) {
			perror("fadvise");
			do_exit(1);
		}
	}
	return 0;
}

int main(int argc, char *argv[])
{
	int n;

	fd = open("foo", O_CREAT|O_RDWR|O_TRUNC|O_SYNC, 0666);
	if (fd < 0) {
		perror("open");
		do_exit(1);
	}
	if (write(fd, writebuf, sizeof(writebuf)) != sizeof(writebuf)) {
		perror("write");
		do_exit(1);
	}
	map = mmap(0, 4096, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (map == MAP_FAILED) {
		perror("mmap");
		do_exit(1);
	}
	if (clone(unmapper, stack+sizeof(stack),
			CLONE_FILES|CLONE_FS|CLONE_VM, NULL) < 0) {
		perror("clone");
		do_exit(1);
	}
	n = 0;
	while (!exitted) {
		if (pwrite(fd, map, 1, 0) != 1) {
			perror("pwrite");
			do_exit(1);
		}
	}
	exit(0);
}
