/*
 *  powerpc.h
 *  Copyright 2009 Ramon de Carvalho Valle <ramon@risesecurity.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* from Linux 2.6.30 */

struct syscall_table syscall_table[] = {
    { "restart_syscall"           ,   0,   0 },
    { "exit"                      ,   1,   0 },
    { "fork"                      ,   2,   SYSCALL_IGNORE },
    { "read"                      ,   3,   0 },
    { "write"                     ,   4,   0 },
    { "open"                      ,   5,   0 },
    { "close"                     ,   6,   0 },
    { "waitpid"                   ,   7,   0 },
    { "creat"                     ,   8,   0 },
    { "link"                      ,   9,   0 },
    { "unlink"                    ,  10,   0 },
    { "execve"                    ,  11,   0 },
    { "chdir"                     ,  12,   0 },
    { "time"                      ,  13,   0 },
    { "mknod"                     ,  14,   0 },
    { "chmod"                     ,  15,   0 },
    { "lchown"                    ,  16,   0 },
    { "break"                     ,  17,   0 },
    { "oldstat"                   ,  18,   0 },
    { "lseek"                     ,  19,   0 },
    { "getpid"                    ,  20,   0 },
    { "mount"                     ,  21,   0 },
    { "umount"                    ,  22,   0 },
    { "setuid"                    ,  23,   0 },
    { "getuid"                    ,  24,   0 },
    { "stime"                     ,  25,   SYSCALL_IGNORE },
    { "ptrace"                    ,  26,   0 },
    { "alarm"                     ,  27,   0 },
    { "oldfstat"                  ,  28,   0 },
    { "pause"                     ,  29,   0 },
    { "utime"                     ,  30,   0 },
    { "stty"                      ,  31,   0 },
    { "gtty"                      ,  32,   0 },
    { "access"                    ,  33,   0 },
    { "nice"                      ,  34,   0 },
    { "ftime"                     ,  35,   0 },
    { "sync"                      ,  36,   0 },
    { "kill"                      ,  37,   0 },
    { "rename"                    ,  38,   0 },
    { "mkdir"                     ,  39,   0 },
    { "rmdir"                     ,  40,   0 },
    { "dup"                       ,  41,   0 },
    { "pipe"                      ,  42,   0 },
    { "times"                     ,  43,   0 },
    { "prof"                      ,  44,   0 },
    { "brk"                       ,  45,   0 },
    { "setgid"                    ,  46,   0 },
    { "getgid"                    ,  47,   0 },
    { "signal"                    ,  48,   0 },
    { "geteuid"                   ,  49,   0 },
    { "getegid"                   ,  50,   0 },
    { "acct"                      ,  51,   0 },
    { "umount2"                   ,  52,   0 },
    { "lock"                      ,  53,   0 },
    { "ioctl"                     ,  54,   0 },
    { "fcntl"                     ,  55,   0 },
    { "mpx"                       ,  56,   0 },
    { "setpgid"                   ,  57,   0 },
    { "ulimit"                    ,  58,   0 },
    { "oldolduname"               ,  59,   0 },
    { "umask"                     ,  60,   0 },
    { "chroot"                    ,  61,   0 },
    { "ustat"                     ,  62,   0 },
    { "dup2"                      ,  63,   0 },
    { "getppid"                   ,  64,   0 },
    { "getpgrp"                   ,  65,   0 },
    { "setsid"                    ,  66,   0 },
    { "sigaction"                 ,  67,   0 },
    { "sgetmask"                  ,  68,   0 },
    { "ssetmask"                  ,  69,   0 },
    { "setreuid"                  ,  70,   0 },
    { "setregid"                  ,  71,   0 },
    { "sigsuspend"                ,  72,   0 },
    { "sigpending"                ,  73,   0 },
    { "sethostname"               ,  74,   0 },
    { "setrlimit"                 ,  75,   0 },
    { "getrlimit"                 ,  76,   0 },
    { "getrusage"                 ,  77,   0 },
    { "gettimeofday"              ,  78,   0 },
    { "settimeofday"              ,  79,   0 },
    { "getgroups"                 ,  80,   0 },
    { "setgroups"                 ,  81,   0 },
    { "select"                    ,  82,   0 },
    { "symlink"                   ,  83,   0 },
    { "oldlstat"                  ,  84,   0 },
    { "readlink"                  ,  85,   0 },
    { "uselib"                    ,  86,   0 },
    { "swapon"                    ,  87,   0 },
    { "reboot"                    ,  88,   SYSCALL_IGNORE },
    { "readdir"                   ,  89,   0 },
    { "mmap"                      ,  90,   0 },
    { "munmap"                    ,  91,   0 },
    { "truncate"                  ,  92,   0 },
    { "ftruncate"                 ,  93,   0 },
    { "fchmod"                    ,  94,   0 },
    { "fchown"                    ,  95,   0 },
    { "getpriority"               ,  96,   0 },
    { "setpriority"               ,  97,   0 },
    { "profil"                    ,  98,   0 },
    { "statfs"                    ,  99,   0 },
    { "fstatfs"                   , 100,   0 },
    { "ioperm"                    , 101,   0 },
    { "socketcall"                , 102,   0 },
    { "syslog"                    , 103,   0 },
    { "setitimer"                 , 104,   0 },
    { "getitimer"                 , 105,   0 },
    { "stat"                      , 106,   0 },
    { "lstat"                     , 107,   0 },
    { "fstat"                     , 108,   0 },
    { "olduname"                  , 109,   0 },
    { "iopl"                      , 110,   0 },
    { "vhangup"                   , 111,   SYSCALL_IGNORE },
    { "idle"                      , 112,   0 },
    { "vm86"                      , 113,   0 },
    { "wait4"                     , 114,   0 },
    { "swapoff"                   , 115,   0 },
    { "sysinfo"                   , 116,   0 },
    { "ipc"                       , 117,   0 },
    { "fsync"                     , 118,   0 },
    { "sigreturn"                 , 119,   0 },
    { "clone"                     , 120,   SYSCALL_IGNORE },
    { "setdomainname"             , 121,   0 },
    { "uname"                     , 122,   0 },
    { "modify_ldt"                , 123,   0 },
    { "adjtimex"                  , 124,   0 },
    { "mprotect"                  , 125,   0 },
    { "sigprocmask"               , 126,   0 },
    { "create_module"             , 127,   0 },
    { "init_module"               , 128,   0 },
    { "delete_module"             , 129,   0 },
    { "get_kernel_syms"           , 130,   0 },
    { "quotactl"                  , 131,   0 },
    { "getpgid"                   , 132,   0 },
    { "fchdir"                    , 133,   0 },
    { "bdflush"                   , 134,   0 },
    { "sysfs"                     , 135,   0 },
    { "personality"               , 136,   0 },
    { "afs_syscall"               , 137,   0 },
    { "setfsuid"                  , 138,   0 },
    { "setfsgid"                  , 139,   0 },
    { "_llseek"                   , 140,   0 },
    { "getdents"                  , 141,   0 },
    { "_newselect"                , 142,   0 },
    { "flock"                     , 143,   0 },
    { "msync"                     , 144,   0 },
    { "readv"                     , 145,   0 },
    { "writev"                    , 146,   0 },
    { "getsid"                    , 147,   0 },
    { "fdatasync"                 , 148,   0 },
    { "_sysctl"                   , 149,   0 },
    { "mlock"                     , 150,   0 },
    { "munlock"                   , 151,   0 },
    { "mlockall"                  , 152,   0 },
    { "munlockall"                , 153,   0 },
    { "sched_setparam"            , 154,   0 },
    { "sched_getparam"            , 155,   0 },
    { "sched_setscheduler"        , 156,   0 },
    { "sched_getscheduler"        , 157,   0 },
    { "sched_yield"               , 158,   0 },
    { "sched_get_priority_max"    , 159,   0 },
    { "sched_get_priority_min"    , 160,   0 },
    { "sched_rr_get_interval"     , 161,   0 },
    { "nanosleep"                 , 162,   0 },
    { "mremap"                    , 163,   0 },
    { "setresuid"                 , 164,   0 },
    { "getresuid"                 , 165,   0 },
    { "query_module"              , 166,   0 },
    { "poll"                      , 167,   0 },
    { "nfsservctl"                , 168,   0 },
    { "setresgid"                 , 169,   0 },
    { "getresgid"                 , 170,   0 },
    { "prctl"                     , 171,   0 },
    { "rt_sigreturn"              , 172,   0 },
    { "rt_sigaction"              , 173,   0 },
    { "rt_sigprocmask"            , 174,   0 },
    { "rt_sigpending"             , 175,   0 },
    { "rt_sigtimedwait"           , 176,   0 },
    { "rt_sigqueueinfo"           , 177,   0 },
    { "rt_sigsuspend"             , 178,   0 },
    { "pread64"                   , 179,   0 },
    { "pwrite64"                  , 180,   0 },
    { "chown"                     , 181,   0 },
    { "getcwd"                    , 182,   0 },
    { "capget"                    , 183,   0 },
    { "capset"                    , 184,   0 },
    { "sigaltstack"               , 185,   0 },
    { "sendfile"                  , 186,   0 },
    { "getpmsg"                   , 187,   0 },
    { "putpmsg"                   , 188,   0 },
    { "vfork"                     , 189,   SYSCALL_IGNORE },
    { "ugetrlimit"                , 190,   0 },
    { "readahead"                 , 191,   0 },
#ifndef __powerpc64__
    { "mmap2"                     , 192,   0 },
    { "truncate64"                , 193,   0 },
    { "ftruncate64"               , 194,   0 },
    { "stat64"                    , 195,   0 },
    { "lstat64"                   , 196,   0 },
    { "fstat64"                   , 197,   0 },
#endif
    { "pciconfig_read"            , 198,   0 },
    { "pciconfig_write"           , 199,   0 },
    { "pciconfig_iobase"          , 200,   0 },
    { "multiplexer"               , 201,   0 },
    { "getdents64"                , 202,   0 },
    { "pivot_root"                , 203,   0 },
#ifndef __powerpc64__
    { "fcntl64"                   , 204,   0 },
#endif
    { "madvise"                   , 205,   0 },
    { "mincore"                   , 206,   0 },
    { "gettid"                    , 207,   0 },
    { "tkill"                     , 208,   0 },
    { "setxattr"                  , 209,   0 },
    { "lsetxattr"                 , 210,   0 },
    { "fsetxattr"                 , 211,   0 },
    { "getxattr"                  , 212,   0 },
    { "lgetxattr"                 , 213,   0 },
    { "fgetxattr"                 , 214,   0 },
    { "listxattr"                 , 215,   0 },
    { "llistxattr"                , 216,   0 },
    { "flistxattr"                , 217,   0 },
    { "removexattr"               , 218,   0 },
    { "lremovexattr"              , 219,   0 },
    { "fremovexattr"              , 220,   0 },
    { "futex"                     , 221,   0 },
    { "sched_setaffinity"         , 222,   0 },
    { "sched_getaffinity"         , 223,   0 },
    { "tuxcall"                   , 225,   0 },
#ifndef __powerpc64__
    { "sendfile64"                , 226,   0 },
#endif
    { "io_setup"                  , 227,   0 },
    { "io_destroy"                , 228,   0 },
    { "io_getevents"              , 229,   0 },
    { "io_submit"                 , 230,   0 },
    { "io_cancel"                 , 231,   0 },
    { "set_tid_address"           , 232,   0 },
    { "fadvise64"                 , 233,   0 },
    { "exit_group"                , 234,   0 },
    { "lookup_dcookie"            , 235,   0 },
    { "epoll_create"              , 236,   0 },
    { "epoll_ctl"                 , 237,   0 },
    { "epoll_wait"                , 238,   0 },
    { "remap_file_pages"          , 239,   0 },
    { "timer_create"              , 240,   0 },
    { "timer_settime"             , 241,   0 },
    { "timer_gettime"             , 242,   0 },
    { "timer_getoverrun"          , 243,   0 },
    { "timer_delete"              , 244,   0 },
    { "clock_settime"             , 245,   0 },
    { "clock_gettime"             , 246,   0 },
    { "clock_getres"              , 247,   0 },
    { "clock_nanosleep"           , 248,   0 },
    { "swapcontext"               , 249,   0 },
    { "tgkill"                    , 250,   0 },
    { "utimes"                    , 251,   0 },
    { "statfs64"                  , 252,   0 },
    { "fstatfs64"                 , 253,   0 },
#ifndef __powerpc64__
    { "fadvise64_64"              , 254,   0 },
#endif
    { "rtas"                      , 255,   0 },
    { "sys_debug_setcontext"      , 256,   0 },
    { "migrate_pages"             , 258,   0 },
    { "mbind"                     , 259,   0 },
    { "get_mempolicy"             , 260,   0 },
    { "set_mempolicy"             , 261,   0 },
    { "mq_open"                   , 262,   0 },
    { "mq_unlink"                 , 263,   0 },
    { "mq_timedsend"              , 264,   0 },
    { "mq_timedreceive"           , 265,   0 },
    { "mq_notify"                 , 266,   0 },
    { "mq_getsetattr"             , 267,   0 },
    { "kexec_load"                , 268,   0 },
    { "add_key"                   , 269,   0 },
    { "request_key"               , 270,   0 },
    { "keyctl"                    , 271,   0 },
    { "waitid"                    , 272,   0 },
    { "ioprio_set"                , 273,   0 },
    { "ioprio_get"                , 274,   0 },
    { "inotify_init"              , 275,   0 },
    { "inotify_add_watch"         , 276,   0 },
    { "inotify_rm_watch"          , 277,   0 },
    { "spu_run"                   , 278,   0 },
    { "spu_create"                , 279,   0 },
    { "pselect6"                  , 280,   0 },
    { "ppoll"                     , 281,   0 },
    { "unshare"                   , 282,   0 },
    { "splice"                    , 283,   0 },
    { "tee"                       , 284,   0 },
    { "vmsplice"                  , 285,   0 },
    { "openat"                    , 286,   0 },
    { "mkdirat"                   , 287,   0 },
    { "mknodat"                   , 288,   0 },
    { "fchownat"                  , 289,   0 },
    { "futimesat"                 , 290,   0 },
#ifdef __powerpc64__
    { "newfstatat"                , 291,   0 },
#else
    { "fstatat64"                 , 291,   0 },
#endif
    { "unlinkat"                  , 292,   0 },
    { "renameat"                  , 293,   0 },
    { "linkat"                    , 294,   0 },
    { "symlinkat"                 , 295,   0 },
    { "readlinkat"                , 296,   0 },
    { "fchmodat"                  , 297,   0 },
    { "faccessat"                 , 298,   0 },
    { "get_robust_list"           , 299,   0 },
    { "set_robust_list"           , 300,   0 },
    { "move_pages"                , 301,   0 },
    { "getcpu"                    , 302,   0 },
    { "epoll_pwait"               , 303,   0 },
    { "utimensat"                 , 304,   0 },
    { "signalfd"                  , 305,   0 },
    { "timerfd_create"            , 306,   0 },
    { "eventfd"                   , 307,   0 },
    { "sync_file_range2"          , 308,   0 },
    { "fallocate"                 , 309,   0 },
    { "subpage_prot"              , 310,   0 },
    { "timerfd_settime"           , 311,   0 },
    { "timerfd_gettime"           , 312,   0 },
    { "signalfd4"                 , 313,   0 },
    { "eventfd2"                  , 314,   0 },
    { "epoll_create1"             , 315,   0 },
    { "dup3"                      , 316,   0 },
    { "pipe2"                     , 317,   0 },
    { "inotify_init1"             , 318,   0 },
    { "preadv"                    , 320,   0 },
    { "pwritev"                   , 321,   0 },
    { "syscalls"                  , 322,   0 },
    { "_exit"                     ,   0,   0 },
    { ""                          ,   0,   SYSCALL_END }
};
