/*
 * Truncate the named file to the identified size
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

int main(int argc, char *argv[])
{
	int fd;
	loff_t size;
	char *filename;

	if (argc != 3) {
		fprintf(stderr, "Usage; %s filename size-to_truncate_to\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_CREAT|O_RDWR, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	sscanf(argv[2], "%Ld", &size);
	printf("%s: truncating `%s' to size %Ld\n", argv[0], filename, size);
	if (ftruncate64(fd, size) < 0) {
		fprintf(stderr, "%s: error truncating `%s' to size %Ld: %s\n",
			argv[0], filename, size, strerror(errno));
		exit(1);
	}
	exit(0);
}
