/*
 * Write all over a file.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <limits.h>
#include <sys/stat.h>

#include "fadvise.h"

char *progname;
int o_sync;

#define CHUNK 8192

void usage(void)
{
	fprintf(stderr, "Usage: %s [-o] filename nr_operations\n", progname);
	fprintf(stderr, "    -o:       Use O_SYNC\n");
	
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;
	int nr_operations;
	int fd;
	char *filename;
	struct stat statbuf;
	off_t size;
	int i;
	char *p = malloc(CHUNK);

	progname = argv[0];
	while ((c = getopt(argc, argv, "von:t:")) != -1) {
		switch (c) {
		case 'o':
			o_sync = O_SYNC;
			break;
		default:
			usage();
			break;
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];
	if (optind == argc)
		usage();
	sscanf(argv[optind++], "%d", &nr_operations);
	if (optind != argc)
		usage();

	fd = open(filename, O_RDWR|o_sync);
	if (fd < 0) {
		perror("open");
		exit(1);
	}

	fstat(fd, &statbuf);
	if (S_ISBLK(statbuf.st_mode)) {
		size = INT_MAX;
	} else {
		size = statbuf.st_size;
	}

	srand(getpid());

	for (i = 0; i < nr_operations; i++) {
		off_t offset;
		int ret;

		offset = rand() % size;
		ret = pwrite(fd, p, CHUNK, offset & ~(CHUNK - 1));
		if (ret != CHUNK) {
			perror("pwrite");
			fprintf(stderr, "pwrite at %ld returned %d\n",
					(long)offset, ret);
			exit(1);
		}
	}
			
	exit(0);
}
