/*
 * open, write, close, map, unlink, open, write, close
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/mman.h>
#include <string.h>
#include <time.h>
#include "write-struct.h"

char *progname;
void *mapped_mem;

void usage(void)
{
	fprintf(stderr, "Usage: %s filename1 filename2\n", progname);
}

int rand_of(int arg)
{
	double dret = arg;
	loff_t ret;

	dret *= drand48();
	ret = dret;
	if (ret < 0 || ret > 0x40000000)
		printf("I goofed: %Ld\n", ret);
	return ret;
}

int open_file(char *filename, int flags)
{
	int fd = open(filename, flags, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			progname, filename, strerror(errno));
		exit(1);
	}
	return fd;
}

ssize_t my_pwrite(unsigned int fd, const char * buf, size_t count, loff_t pos)
{
	if (pos > 2000000000)
		printf("DRAT\n");
	return pwrite(fd, buf, count, pos);
}

int __akpm_write(char *filename, int fd, size_t count)
{
	static struct write_struct write_buffer[70020 /
			sizeof(struct write_struct)];
	unsigned long ino;
	unsigned long file_offset;
	unsigned long aligned_offset;
	unsigned array_offset;
	unsigned last_array_offset;
	struct stat st;
	time_t now = time(0);

	fstat(fd, &st);
	ino = st.st_ino;

	file_offset = lseek(fd, 0, SEEK_CUR);
	aligned_offset = file_offset & ~(sizeof(struct write_struct) - 1);
	last_array_offset = count / sizeof(struct write_struct) + 2;

	for (array_offset = 0; array_offset < last_array_offset;
			array_offset++) {
		write_buffer[array_offset].sequence = ino + aligned_offset;
		write_buffer[array_offset].ino = ino;
		write_buffer[array_offset].line_count = 0;
		write_buffer[array_offset].now = now;
		write_buffer[array_offset].offset = aligned_offset +
			array_offset * sizeof(struct write_struct);
		strncpy(write_buffer[array_offset].filename,
			filename,
			sizeof(write_buffer[array_offset].filename));
		aligned_offset += sizeof(struct write_struct);
	}
	return write(	fd,
			((char *)write_buffer) +
			(file_offset & (sizeof(struct write_struct) - 1)),
			count);
}

int akpm_write(char *filename, int fd, const size_t __count)
{
	size_t amt;
	int ret;
	size_t count = __count;

	while (count) {
		amt = count;
		if (amt > 65536)
			amt = 65536;
		ret = __akpm_write(filename, fd, amt);
		if (ret != amt) {
			printf("%s: wrote %d, not %d\n", __FUNCTION__, ret, amt);
			return -1;
		}
		count -= amt;
	}
	return __count;
}

void mmap_file(int fd, int size)
{
	mapped_mem = mmap(0, size, PROT_READ|PROT_EXEC, MAP_PRIVATE, fd, 0);
	if (mapped_mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
}

void doit(char *filename1, char *filename2)
{
	int fd;
	int size;
	void *to;

	fd = open_file(filename1, O_RDWR|O_TRUNC|O_CREAT);
	akpm_write(filename1, fd, size = rand_of(50000));
	close(fd);
//	usleep(rand_of(2 * 1000 * 1000));

	to = malloc(size);
	if (to == 0) {
		perror("mem");
		exit(1);
	}
	fd = open_file(filename1, O_RDONLY);
	mmap_file(fd, size);
	memcpy(to, mapped_mem, size);
	close(fd);

//	usleep(rand_of(1 * 1000 * 1000));

	unlink(filename1);

	fd = open_file(filename2, O_RDWR|O_TRUNC|O_CREAT);
	akpm_write(filename2, fd, size = rand_of(40000));
	close(fd);
}

int main(int argc, char *argv[])
{
	progname = argv[0];

	if (argc != 3)
		usage();
	srand48(time(0) * getpid());
	srand(10 * getpid());
	doit(argv[1], argv[2]);
	exit(0);
}
