/*
 * See what happens when we run out of disk space via a write()
 * to the middle of a file.
 */

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

char buf[4096];

int main(int argc, char *argv[])
{
	int fd;
	loff_t size;
	char *filename;
	loff_t to_write;

	if (argc != 3) {
		fprintf(stderr, "Usage; %s filename size\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_CREAT|O_TRUNC|O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	sscanf(argv[2], "%Ld", &size);
	if (pwrite(fd, buf, 1, size - 1) != 1) {
		fprintf(stderr, "%s: error pwriting: %s\n",
			argv[0], strerror(errno));
		exit(1);
	}

	to_write = size;
	lseek(fd, 0, SEEK_SET);
	while (to_write) {
		loff_t chunk = to_write;

		if (chunk > sizeof(buf))
			chunk = sizeof(buf);
		if (write(fd, buf, chunk) != chunk) {
			fprintf(stderr, "%s: error writing: %s\n",
				argv[0], strerror(errno));
			exit(1);
		}
		to_write -= chunk;
	}
	exit(0);
}
